#!/usr/bin/env python
# Hide Children
# Copyright 2007 by Brian C. Christensen

#    This file is part of GanttPV.
#
#    GanttPV is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    GanttPV is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with GanttPV; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# 070227 - first draft

def hint(s):
    try:
        Data.Hint("%s: %s" % (scriptname, s))
    except AttributeError:
        self.SetStatusText(s)

if debug: print 'Start Script'

def Hide(self):

    # set local pointers to tables
    rid = self.ReportID  # current report
    drep = Data.Database['Report']
    drow = Data.Database['ReportRow']
    drt = Data.Database['ReportType']
    rr = drep[rid]

    # make sure report has report type
    if not rr.has_key('ReportTypeID') or not drt.has_key(rr['ReportTypeID']): 
        if debug: print "ReportType key not found"
        hint("Error: Can't find type of this report.")
        return
    rtid = rr['ReportTypeID']

    rt = drt[rtid] # pointer to report type record
    ta = rt.get('TableA')
    # tb = rt.get('TableB')  # if two table report all inserts go at the end (less confusing to user)

    # find the selected rows
    sel = self.Report.GetSelectedRows()  # current selection
    if len(sel) <= 0:
        if not self.Report.table.rows:  # if report is empty
            return
        sel = [self.Report.GetGridCursorRow()]  # if no rows are selected, use cursor row

    rows = self.Report.table.rows
    # get table ids for all selected primary table rows
    ids = [ drow[rows[x]].get('TableID') for x in sel if drow[rows[x]].get('TableName') == ta ]
    if len(ids) < 1:
        hint("Must select at least one %s row." & _(ta))
        return

    # hide any row that has a selected row as a parent
    changed = False
    for rowid in Data.GetRowList(rid):
        table = drow[rowid].get('TableName')
        id = drow[rowid].get('TableID')
        if table in Data.Database and id in Data.Database[table]:
            if Data.Database[table][id].get(ta + 'ID') in ids and not drow[rowid].get('Hidden'):
                change = { 'Table': 'ReportRow', 'ID': rowid, 'Hidden': True }
                Data.Update(change)
                changed = True

    if changed:
        Data.SetUndo('Hide Children')

Hide(self)

if debug: print 'End Script'
